/*
 * Decompiled with CFR 0.152.
 */
package js.java.tools.gui.dataTransferDisplay;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import js.java.tools.gui.GraphicTools;

public class LedComponent
extends JComponent {
    boolean mode = false;
    LEDCOLOR cmode = LEDCOLOR.GREEN;
    private LedPainter painter = new ThreeDPainter();

    public LedComponent() {
        Dimension dim = new Dimension(19, 19);
        this.setMinimumSize(new Dimension(15, 15));
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.setOpaque(false);
    }

    public LedComponent(LEDCOLOR col) {
        this();
        this.cmode = col;
    }

    public void setPainter(LedPainter p) {
        this.painter = p;
    }

    public void setLed(boolean on) {
        this.mode = on;
        this.repaint();
    }

    public void setColor(LEDCOLOR col) {
        this.cmode = col;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.painter.paintComponent(g, this);
    }

    public static enum LEDCOLOR {
        GREEN(new Color(68, 255, 68), new Color(0, 119, 0)),
        YELLOW(new Color(255, 255, 68), new Color(119, 119, 0)),
        RED(new Color(204, 0, 0), new Color(102, 0, 0));

        private Color trueColor;
        private Color falseColor;

        private LEDCOLOR(Color trueColor, Color falseColor) {
            this.trueColor = trueColor;
            this.falseColor = falseColor;
        }

        Color colTrue() {
            return this.trueColor;
        }

        Color colFalse() {
            return this.falseColor;
        }
    }

    public static class ThreeDPainter
    implements LedPainter {
        @Override
        public void paintComponent(Graphics g, LedComponent p) {
            RadialGradientPaint rgp;
            Graphics2D g2 = (Graphics2D)g;
            GraphicTools.enableGfxAA((Graphics2D)g2);
            int b = 4;
            int x = 4;
            int y = 4;
            int w = p.getWidth() - 8;
            int h = p.getHeight() - 8;
            w = h = Math.min(w, h);
            Point2D.Float center = new Point2D.Float(x + w / 3, y + 2);
            float radius = 10.0f;
            float[] dist = new float[]{0.2f, 0.7f, 1.0f};
            Color ocol = Color.BLACK;
            if (p.mode) {
                Color[] colors = new Color[]{p.cmode.colTrue().brighter().brighter(), p.cmode.colTrue(), Color.BLACK};
                rgp = new RadialGradientPaint(center, radius, dist, colors);
                ocol = p.cmode.colTrue().brighter();
            } else {
                Color[] colors = new Color[]{p.cmode.colFalse(), p.cmode.colFalse().darker(), Color.BLACK};
                rgp = new RadialGradientPaint(center, radius, dist, colors);
            }
            g2.setPaint(rgp);
            g2.fillOval(x, y, w, h);
            g2.setColor(ocol);
            g2.drawOval(x, y, w, h);
        }
    }

    public static class SimplePainter
    implements LedPainter {
        @Override
        public void paintComponent(Graphics g, LedComponent p) {
            Graphics2D g2 = (Graphics2D)g;
            GraphicTools.enableGfxAA((Graphics2D)g2);
            int b = 4;
            int x = 4;
            int y = 4;
            int w = p.getWidth() - 8;
            int h = p.getHeight() - 8;
            w = h = Math.min(w, h);
            if (p.mode) {
                g2.setColor(p.cmode.colTrue());
            } else {
                g2.setColor(p.cmode.colFalse());
            }
            g2.fillOval(x, y, w, h);
            g2.setColor(Color.BLACK);
            g2.drawOval(x, y, w, h);
        }
    }

    public static interface LedPainter {
        public void paintComponent(Graphics var1, LedComponent var2);
    }
}

