/*
 */
package js.java.plugins.monitorWand;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JMenu;
import js.java.plugins.monitorWand.connection.Abfahrten;
import js.java.schaltungen.timesystem.TimeFormat;

/**
 *
 * @author js
 */
public class wand extends JComponent
{

    static final private int BIGFONTHEIGHT = 22;
    static final private int NORMALFONTHEIGHT = 18;
    static final private int SMALLFONTHEIGHT = 14;
    private int bigfontheight;
    private int normalfontheight;
    private int smallfontheight;
    private ActionListener refreshListener = new ActionListener()
    {

        @Override
        public void actionPerformed(ActionEvent e)
        {
            a = c.getAbfahrten();
            x = 0;
            repaint();
        }
    };
    private ActionListener scrollListener = new ActionListener()
    {

        @Override
        public void actionPerformed(ActionEvent e)
        {
            if (a != null)
            {
                x += scaleOffset;
                repaint();
            }
        }
    };
    private javax.swing.Timer refreshTimer = new javax.swing.Timer(1000 * 30, refreshListener);
    private javax.swing.Timer scrollTimer = new javax.swing.Timer(70, scrollListener);
    private Color bgcolor = new Color(0x00, 0x00, 0xcc);
    private Color fgcolor = new Color(0xff, 0xff, 0xff);
    private Font bigfont;
    private Font normalfont;
    private Font smallfont;
    private final connection c;
    private TreeSet<Abfahrten> a = null;
    private int scaleOffset = 1;
    private int x = 0;
    private TimeFormat tf = TimeFormat.getInstance(TimeFormat.STYLE.HM);

    wand(connection c)
    {
        this.c = c;
        this.setOpaque(true);
        setScale(0);
        refreshTimer.start();
        scrollTimer.start();
    }

    void setScale(int value)
    {
        bigfontheight = BIGFONTHEIGHT * (10 + value) / 10;
        normalfontheight = NORMALFONTHEIGHT * (10 + value) / 10;
        smallfontheight = SMALLFONTHEIGHT * (10 + value) / 10;
        bigfont = new Font(Font.SANS_SERIF, Font.BOLD, bigfontheight);
        normalfont = new Font(Font.SANS_SERIF, Font.PLAIN, normalfontheight);
        smallfont = new Font(Font.SANS_SERIF, Font.BOLD, smallfontheight);
        scaleOffset = (10 + value) / 10 / 2 + 1;
        repaint();
    }

    @Override
    public void paintComponent(Graphics g)
    {
        Graphics2D g2 = (Graphics2D) g;
        g2.setColor(bgcolor);
        g2.fillRect(0, 0, getWidth(), getHeight());

        drawHead(g2);
        drawTrains(g2);
    }

    private void drawHead(Graphics2D g2)
    {
        g2.setColor(fgcolor);
        g2.fillRect(0, 0, getWidth(), bigfontheight + 6);
        g2.setColor(bgcolor);
        g2.setFont(bigfont);
        FontMetrics fm = g2.getFontMetrics();
        g2.drawString("Abfahrt", 10, bigfontheight - fm.getDescent() + 4);
        g2.drawString(c.getName(), bigfontheight * 5, bigfontheight - fm.getDescent() + 4);

        String time = tf.formatTime(c.getSimutime());
        g2.drawString(time, getWidth() - bigfontheight * 3, bigfontheight - fm.getDescent() + 4);
    }

    /**
     * Der Timer hat alle 30 Sekunden eine neue Zugliste abgeholt. Diese Liste wird nun
     * einfach der Reihe nach ausgegeben bis der Ausgabebereich voll ist - oder die Liste leer.
     * @param g2
     */
    private void drawTrains(Graphics2D g2)
    {
        if (a != null)
        {
            int y = bigfontheight + 10;
            for (Abfahrten f : a)
            {
                y += normalfontheight;
                if (y > getHeight())
                {
                    break;
                }
                g2.setColor(fgcolor);
                g2.setFont(normalfont);
                FontMetrics fm = g2.getFontMetrics();
                g2.drawString(f.ab, 20, y - fm.getDescent());
                g2.drawString(f.name, bigfontheight * 3, y - fm.getDescent());
                g2.drawString(f.nach, bigfontheight * 8, y - fm.getDescent());

                int w = fm.stringWidth(f.gleis);
                g2.setColor(bgcolor);
                g2.fillRect(getWidth() - w - 10 - 10, y - normalfontheight, w + 20, normalfontheight);
                g2.setColor(fgcolor);
                g2.drawString(f.gleis, getWidth() - w - 10, y - fm.getDescent());

                if (!f.infotext.isEmpty())
                {
                    y += smallfontheight + 2;
                    g2.fillRect(0, y - smallfontheight - 2, getWidth(), smallfontheight + 5);
                    g2.setColor(bgcolor);
                    g2.setFont(smallfont);
                    fm = g2.getFontMetrics();
                    w = fm.stringWidth(f.infotext);
                    int cnt = 0;
                    do
                    {
                        g2.drawString(f.infotext, -x + w * cnt, y - fm.getDescent() + 2);
                        cnt++;
                    }
                    while (-x + w * (cnt - 1) < getWidth());
                    y += 5;
                }
                y += 5;
            }
        }
    }
}
