/*
 * Decompiled with CFR 0.152.
 */
package js.java.stspluginlib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import js.java.schaltungen.flagdata;
import js.java.schaltungen.sim.plugin.xmlResponse;
import js.java.schaltungen.timesystem.TimeFormat;
import js.java.tools.xml.xmllistener;
import js.java.tools.xml.xmlreader;
import org.xml.sax.Attributes;

public abstract class PluginClient
implements Runnable,
xmllistener {
    private static final int PORT = 3691;
    private static final String PROTOCOLLVERSION = "1";
    private Socket tcp = null;
    private BufferedReader input;
    private BufferedWriter output;
    private xmlreader xmlr = new xmlreader();
    private Thread listenThread = null;
    private final String name;
    private final String author;
    private final String version;
    private final String text;
    private long simusynctime;
    private long simutime;
    private xmlResponse sender = new xmlResponse();
    private HashMap<String, HashSet<String>> blhash = null;
    private String blname = null;
    private HashMap<Integer, String> zghash = null;
    private LinkedList<ZugFahrplanZeile> fplhash = null;
    private int fplzid;

    protected PluginClient(String name, String author, String version, String text) {
        this.name = name;
        this.author = author;
        this.version = version;
        this.text = text;
        this.xmlr.registerTag("status", this);
        this.xmlr.registerTag("anlageninfo", this);
        this.xmlr.registerTag("bahnsteigliste", this);
        this.xmlr.registerTag("bahnsteig", this);
        this.xmlr.registerTag("n", this);
        this.xmlr.registerTag("zugliste", this);
        this.xmlr.registerTag("zug", this);
        this.xmlr.registerTag("zugdetails", this);
        this.xmlr.registerTag("zugfahrplan", this);
        this.xmlr.registerTag("gleis", this);
        this.xmlr.registerTag("simzeit", this);
        this.xmlr.registerTag("ereignis", this);
    }

    public void close() {
        System.out.println("Verbindung getrennt");
        if (this.tcp != null) {
            try {
                this.tcp.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.closed();
        }
        this.tcp = null;
        this.input = null;
        this.output = null;
        if (this.listenThread != null) {
            this.listenThread.stop();
        }
        this.listenThread = null;
    }

    public void connect(String host) throws IOException {
        this.close();
        this.tcp = new Socket(host, 3691);
        this.input = new BufferedReader(new InputStreamReader(this.tcp.getInputStream(), "UTF-8"));
        this.output = new BufferedWriter(new OutputStreamWriter(this.tcp.getOutputStream(), "UTF-8"));
        this.listenThread = new Thread(this);
        this.listenThread.setName("listenThread");
        this.listenThread.start();
        System.out.println("Verbunden");
    }

    private void sendLine(String cmd, HashMap<String, String> attr) {
        if (this.output == null) {
            throw new IllegalStateException("Not connected");
        }
        this.sender.sendLine(this.output, cmd, attr);
    }

    private void sendLine(String cmd, String ... v) {
        if (this.output == null) {
            throw new IllegalStateException("Not connected");
        }
        this.sender.sendLine(this.output, cmd, v);
    }

    public long getSimutime() {
        return this.simutime + (System.currentTimeMillis() - this.simusynctime);
    }

    private void setTime(long sendert, long t) {
        this.simusynctime = System.currentTimeMillis();
        this.simutime = t + (this.simusynctime - sendert) / 2L;
    }

    @Override
    public final void run() {
        while (true) {
            try {
                while (true) {
                    String l = "";
                    while (!this.xmlr.isCleanXML(l = l + this.input.readLine())) {
                    }
                    this.xmlr.updateDataByString(l);
                }
            }
            catch (IOException e) {
                System.out.println("IO-Fehler, Verbindung geschlossen");
                this.listenThread = null;
                this.close();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public final void parseStartTag(String tag, Attributes attrs) {
        try {
            if (tag.equals("status")) {
                int code = Integer.parseInt(attrs.getValue("code"));
                if (code == 300) {
                    this.sendLine("register", "name", this.name, "autor", this.author, "version", this.version, "protokoll", PROTOCOLLVERSION, "text", this.text);
                } else if (code == 220) {
                    this.request_simzeit();
                    this.connected();
                }
            } else if (tag.equals("anlageninfo")) {
                this.response_anlageninfo(Integer.parseInt(attrs.getValue("aid")), attrs.getValue("name"), attrs.getValue("simbuild"));
            } else if (tag.equals("zugdetails")) {
                this.response_zugdetails(Integer.parseInt(attrs.getValue("zid")), new ZugDetails(attrs));
            } else if (tag.equals("ereignis")) {
                this.response_ereignis(Integer.parseInt(attrs.getValue("zid")), attrs.getValue("art"), new ZugDetails(attrs));
            } else if (tag.equals("bahnsteigliste")) {
                this.blhash = new HashMap();
            } else if (tag.equals("bahnsteig") && this.blhash != null) {
                this.blname = attrs.getValue("name");
                this.blhash.put(this.blname, new HashSet());
            } else if (tag.equals("n") && this.blname != null) {
                HashSet<String> h = this.blhash.get(this.blname);
                h.add(attrs.getValue("name"));
            } else if (tag.equals("zugliste")) {
                this.zghash = new HashMap();
            } else if (tag.equals("zug") && this.zghash != null) {
                this.zghash.put(Integer.parseInt(attrs.getValue("zid")), attrs.getValue("name"));
            } else if (tag.equals("zugfahrplan")) {
                this.fplzid = Integer.parseInt(attrs.getValue("zid"));
                this.fplhash = new LinkedList();
            } else if (tag.equals("gleis") && this.fplhash != null) {
                try {
                    this.fplhash.add(new ZugFahrplanZeile(attrs));
                }
                catch (ParseException ex) {}
            } else if (tag.equals("simzeit")) {
                this.setTime(Long.parseLong(attrs.getValue("sender")), Long.parseLong(attrs.getValue("zeit")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void parseEndTag(String tag, Attributes attrs, String pcdata) {
        try {
            if (tag.equals("bahnsteigliste") && this.blhash != null) {
                this.response_bahnsteigliste(this.blhash);
                this.blhash = null;
            } else if (tag.equals("bahnsteig") && this.blhash != null) {
                this.blname = null;
            } else if (tag.equals("zugliste") && this.zghash != null) {
                this.response_zugliste(this.zghash);
                this.zghash = null;
            } else if (tag.equals("zugfahrplan") && this.fplhash != null) {
                this.response_zugfahrplan(this.fplzid, this.fplhash);
                this.fplhash = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void request_simzeit() {
        this.sendLine("simzeit", "sender", Long.toString(System.currentTimeMillis()));
    }

    protected final void request_anlageninfo() {
        this.sendLine("anlageninfo", new String[0]);
    }

    protected final void request_bahnsteigliste() {
        this.sendLine("bahnsteigliste", new String[0]);
    }

    protected final void request_zugliste() {
        this.sendLine("zugliste", new String[0]);
    }

    protected final void request_zugdetails(int zid) {
        this.sendLine("zugdetails", "zid", Integer.toString(zid));
    }

    protected final void request_zugfahrplan(int zid) {
        this.sendLine("zugfahrplan", "zid", Integer.toString(zid));
    }

    protected final void request_setdebug(boolean enabled) {
        this.sendLine("debug", "mode", Boolean.toString(enabled));
    }

    protected final void register_ereignis(int zid, String art) {
        this.sendLine("ereignis", "zid", Integer.toString(zid), " art", art);
    }

    protected abstract void connected();

    protected abstract void closed();

    protected abstract void response_anlageninfo(int var1, String var2, String var3);

    protected abstract void response_bahnsteigliste(HashMap<String, HashSet<String>> var1);

    protected abstract void response_zugliste(HashMap<Integer, String> var1);

    protected abstract void response_zugdetails(int var1, ZugDetails var2);

    protected abstract void response_zugfahrplan(int var1, LinkedList<ZugFahrplanZeile> var2);

    protected void response_ereignis(int zid, String art, ZugDetails zugDetails) {
    }

    public static class ZugDetails {
        public final int zid;
        public final String name;
        public final int verspaetung;
        public final String gleis;
        public final String plangleis;
        public final String von;
        public final String nach;
        public final boolean sichtbar;
        public final boolean amgleis;

        ZugDetails(Attributes attrs) {
            this.zid = Integer.parseInt(attrs.getValue("zid"));
            this.verspaetung = Integer.parseInt(attrs.getValue("verspaetung"));
            this.sichtbar = Boolean.parseBoolean(attrs.getValue("sichtbar"));
            this.amgleis = attrs.getValue("amgleis") != null ? Boolean.parseBoolean(attrs.getValue("amgleis")) : false;
            this.name = attrs.getValue("name");
            this.gleis = attrs.getValue("gleis");
            this.plangleis = attrs.getValue("plangleis");
            this.von = attrs.getValue("von");
            this.nach = attrs.getValue("nach");
        }
    }

    public static class ZugFahrplanZeile {
        public final String plan;
        public final String gleis;
        public final long an;
        public final long ab;
        public final flagdata flags;
        private final TimeFormat mdf = TimeFormat.getInstance(TimeFormat.STYLE.HM);

        ZugFahrplanZeile(Attributes attrs) throws ParseException {
            this.plan = attrs.getValue("plan");
            this.gleis = attrs.getValue("name");
            this.an = attrs.getValue("an").isEmpty() ? 0L : this.mdf.parse(attrs.getValue("an"));
            this.ab = attrs.getValue("ab").isEmpty() ? 0L : this.mdf.parse(attrs.getValue("ab"));
            this.flags = new flagdata(attrs.getValue("flags"));
        }

        public String getFormattedAn() {
            return this.mdf.format(this.an);
        }

        public String getFormattedAb() {
            return this.mdf.format(this.ab);
        }
    }
}

