/*
 * Decompiled with CFR 0.152.
 */
package js.java.schaltungen;

import java.util.ArrayList;
import java.util.IllegalFormatFlagsException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class flagdata
implements Iterable<Integer> {
    private LinkedList<flagelem> fl = new LinkedList();
    private LinkedList<flagelem> staticfl = new LinkedList();

    public flagdata(String flags) throws IllegalFormatFlagsException {
        boolean inBracket = false;
        boolean needBracket = false;
        boolean inBracket2 = false;
        int needBracket2 = 0;
        StringBuffer param = null;
        flags = flags.toUpperCase().trim();
        flagelem fe = null;
        for (int i = 0; i < flags.length(); ++i) {
            char f = flags.charAt(i);
            if (!(f < 'A' || f > 'Z' || inBracket || needBracket || inBracket2)) {
                fe = new flagelem();
                fe.flag = f;
                fe.longflag = f + "";
                this.fl.addLast(fe);
                this.staticfl.add(fe);
                needBracket = f == 'E' || f == 'F' || f == 'K';
                needBracket2 = 0;
                if (f != 'W') continue;
                needBracket2 = 2;
                continue;
            }
            if (f == '(') {
                if (!needBracket) {
                    throw new IllegalFormatFlagsException("keine Klammerparameter erlaubt");
                }
                if (inBracket || inBracket2) {
                    throw new IllegalFormatFlagsException("doppelte Klammern");
                }
                inBracket = true;
                needBracket = false;
                continue;
            }
            if (f == ')' && inBracket) {
                inBracket = false;
                needBracket = false;
                if (fe.data != 0) continue;
                throw new IllegalFormatFlagsException("()-Klammern ohne Inhalt");
            }
            if (f == '[') {
                if (inBracket || inBracket2) {
                    throw new IllegalFormatFlagsException("doppelte Klammern");
                }
                inBracket2 = true;
                param = new StringBuffer();
                continue;
            }
            if (f == ']' && inBracket2) {
                inBracket2 = false;
                --needBracket2;
                if (param.length() <= 0) {
                    throw new IllegalFormatFlagsException("[]-Klammern ohne Inhalt");
                }
                fe.addParam(param.toString().toLowerCase());
                param = null;
                continue;
            }
            if (fe != null && !inBracket && !inBracket2) {
                fe.longflag = fe.longflag + f;
                continue;
            }
            if (Character.isDigit(f) && inBracket) {
                fe.data = fe.data * 10 + Integer.parseInt(f + "");
                continue;
            }
            if ((Character.isLetterOrDigit(f) || f == ',' || f == '-') && inBracket2) {
                param.append(f);
                continue;
            }
            throw new IllegalFormatFlagsException("unerlaubtes Zeichen");
        }
        if (needBracket) {
            throw new IllegalFormatFlagsException("()-Parameter fehlt");
        }
        if (needBracket2 > 0) {
            throw new IllegalFormatFlagsException("[]-Parameter fehlt");
        }
        if (inBracket || inBracket2) {
            throw new IllegalFormatFlagsException("Klammern nicht geschlossen");
        }
    }

    public flagdata() {
        this("", "", "");
    }

    public flagdata(String flags, String flagd, String flagparam) {
        flagelem fe = null;
        StringTokenizer ft = new StringTokenizer(flagd, ",");
        String[] p = null;
        if (flagparam != null && !flagparam.isEmpty()) {
            p = flagparam.split(":");
        }
        for (int i = 0; i < flags.length(); ++i) {
            char f = flags.charAt(i);
            if (f >= 'A' && f <= 'Z') {
                fe = new flagelem();
                fe.flag = f;
                fe.longflag = f + "";
                switch (f) {
                    case 'E': 
                    case 'F': 
                    case 'K': {
                        if (!ft.hasMoreTokens()) break;
                        try {
                            fe.data = Integer.parseInt(ft.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                }
                if (p != null) {
                    for (int j = 0; j < p.length; ++j) {
                        if (!p[j].startsWith(f + "=")) continue;
                        fe.addParam(p[j].substring(2).toLowerCase());
                    }
                }
                this.fl.addLast(fe);
                this.staticfl.add(fe);
                continue;
            }
            if (fe == null) continue;
            fe.longflag = fe.longflag + f;
        }
    }

    public flagdata(flagdata old) {
        for (flagelem f : old.fl) {
            this.fl.addLast(new flagelem(f));
        }
        for (flagelem f : old.staticfl) {
            this.staticfl.addLast(new flagelem(f));
        }
    }

    public void addFlag(char f) {
        flagelem fe = new flagelem();
        fe.flag = f;
        fe.longflag = f + "";
        this.fl.addLast(fe);
        this.staticfl.add(fe);
    }

    public boolean hasFlag(char flag) {
        for (flagelem f : this.fl) {
            if (f.flag != flag) continue;
            return true;
        }
        return false;
    }

    public boolean hadFlag(char flag) {
        for (flagelem f : this.staticfl) {
            if (f.flag != flag) continue;
            return true;
        }
        return false;
    }

    public boolean hasLongFlag(String flag) {
        for (flagelem f : this.staticfl) {
            if (!f.longflag.equalsIgnoreCase(flag)) continue;
            return true;
        }
        return false;
    }

    public String getLongFlag(char flag) {
        for (flagelem f : this.staticfl) {
            if (f.flag != flag) continue;
            return f.longflag;
        }
        return "";
    }

    public boolean replaceFlag(char oldflag, char newflag) {
        boolean ret = false;
        for (flagelem f : this.fl) {
            if (f.flag != oldflag) continue;
            f.flag = newflag;
            ret = true;
        }
        return ret;
    }

    public int dataOfFlag(char flag) {
        for (flagelem f : this.fl) {
            if (f.flag != flag) continue;
            return f.data;
        }
        return 0;
    }

    public ArrayList<String> paramsOfFlag(char flag) {
        for (flagelem f : this.fl) {
            if (f.flag != flag) continue;
            return f.param;
        }
        return null;
    }

    public boolean flagHasParam(char flag, String p) {
        p = p.toLowerCase();
        for (flagelem f : this.fl) {
            if (f.flag != flag) continue;
            return f.param.contains(p);
        }
        return false;
    }

    public boolean removeFlag(char flag) {
        boolean ret = false;
        for (flagelem f : this.fl) {
            if (f.flag != flag) continue;
            this.fl.remove(f);
            ret = true;
            this.removeFlag(flag);
            break;
        }
        return ret;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (flagelem f : this.fl) {
            r.append(f.longflag);
            if (f.data > 0) {
                r.append('(');
                r.append(f.data);
                r.append(')');
            }
            if (f.param == null) continue;
            for (String p : f.param) {
                r.append('[');
                r.append(p);
                r.append(']');
            }
        }
        return r.toString();
    }

    public String getFlags() {
        StringBuilder r = new StringBuilder();
        for (flagelem f : this.fl) {
            r.append(f.longflag);
        }
        return r.toString();
    }

    public String getFlagdata() {
        StringBuilder r = new StringBuilder();
        for (flagelem f : this.fl) {
            if (f.data <= 0) continue;
            if (r.length() > 0) {
                r.append(',');
            }
            r.append(f.data);
        }
        return r.toString();
    }

    public String getFlagparam() {
        StringBuilder r = new StringBuilder();
        for (flagelem f : this.fl) {
            if (f.param == null) continue;
            for (String p : f.param) {
                if (r.length() > 0) {
                    r.append(':');
                }
                r.append(f.flag + "=" + p);
            }
        }
        return r.toString();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new fditerator(this.fl.iterator());
    }

    public Iterator<Character> flagiterator() {
        return new flagiterator(this.fl.iterator());
    }

    private static class fditerator
    implements Iterator<Integer> {
        private Iterator<flagelem> i;

        private fditerator(Iterator<flagelem> iterator) {
            this.i = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public Integer next() {
            return this.i.next().data;
        }
    }

    private static class flagiterator
    implements Iterator<Character> {
        private Iterator<flagelem> i;

        private flagiterator(Iterator<flagelem> iterator) {
            this.i = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public Character next() {
            return Character.valueOf(this.i.next().flag);
        }
    }

    private static class flagelem {
        public char flag;
        public String longflag = "";
        public int data = 0;
        public ArrayList<String> param = null;

        flagelem() {
        }

        flagelem(flagelem other) {
            this.flag = other.flag;
            this.longflag = other.longflag;
            this.data = other.data;
            if (other.param != null) {
                this.param = new ArrayList<String>(other.param);
            }
        }

        public void addParam(String p) {
            if (this.param == null) {
                this.param = new ArrayList();
            }
            this.param.add(p);
        }
    }
}

