/*
 * Decompiled with CFR 0.152.
 */
package js.java.tools;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class TextHelper {
    public static String deAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return str;
        }
    }

    public static String[] cmdSplit(String cmd) {
        ArrayList<String> ret = new ArrayList<String>();
        String s = "";
        boolean inQuote = false;
        for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                if (!(s = s.trim()).isEmpty()) {
                    ret.add(s);
                }
                s = "";
                continue;
            }
            if (c == ' ' && !inQuote) {
                if (!(s = s.trim()).isEmpty()) {
                    ret.add(s);
                }
                s = "";
                continue;
            }
            s = s + c;
        }
        if (!s.isEmpty()) {
            ret.add(s);
        }
        String[] reta = new String[ret.size()];
        return ret.toArray(reta);
    }

    public static String[] tokenizerToArray(StringTokenizer zst) {
        String[] ret = new String[zst.countTokens()];
        int i = 0;
        while (zst.hasMoreTokens()) {
            ret[i] = zst.nextToken();
            ++i;
        }
        return ret;
    }
}

