/*
 * Decompiled with CFR 0.152.
 */
package js.java.tools.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import js.java.tools.gui.dataTransferDisplay.DataTransferDisplayComponent;
import js.java.tools.logging.jstlog;
import js.java.tools.streams.CountInputStream;
import js.java.tools.streams.DataDisplayInputStream;
import js.java.tools.streams.LatinDataOutputStream;
import js.java.tools.urlConnModifier;
import js.java.tools.xml.xmllistener;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class xmlreader
extends DefaultHandler {
    private HashMap<String, xmllistener> listeners = new HashMap();
    private DataTransferDisplayComponent dtdc = null;
    protected long dataSize = 0L;
    private urlConnModifier urlmod = null;
    private LinkedList stack = null;

    public xmlreader() {
    }

    public xmlreader(DataTransferDisplayComponent dtdc) {
        this();
        this.dtdc = dtdc;
    }

    public void registerTag(String tag, xmllistener l) {
        this.listeners.put(tag, l);
    }

    public LinkedList<String> updateData(String url) throws IOException {
        return this.updateData(url, null);
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setUrlConnModifier(urlConnModifier u) {
        this.urlmod = u;
    }

    public boolean isCleanXML(String data) {
        int klc = 0;
        int slc = 0;
        boolean inkl = false;
        boolean otherc = false;
        block5: for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            switch (c) {
                case '<': {
                    ++klc;
                    inkl = true;
                    otherc = false;
                    continue block5;
                }
                case '>': {
                    inkl = false;
                    continue block5;
                }
                case '/': {
                    if (!inkl) continue block5;
                    --klc;
                    if (otherc) continue block5;
                    ++slc;
                    continue block5;
                }
                default: {
                    if (!inkl) continue block5;
                    otherc = true;
                }
            }
        }
        return klc <= slc;
    }

    public LinkedList<String> updateData(String url, StringBuffer senddata) throws IOException {
        BufferedReader input;
        String str;
        CountInputStream inputC;
        LinkedList<String> data = null;
        this.dataSize = 0L;
        if (url.startsWith("http://")) {
            String enc;
            URL u = new URL(url);
            URLConnection urlConn = u.openConnection();
            if (this.urlmod != null) {
                this.urlmod.modify(urlConn);
            }
            urlConn.setDoInput(true);
            if (senddata != null) {
                urlConn.setDoOutput(true);
            }
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Accept-Encoding", "gzip");
            if (senddata != null) {
                urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                LatinDataOutputStream printout = new LatinDataOutputStream(urlConn.getOutputStream());
                String content = senddata.toString();
                printout.write(content);
                printout.flush();
                printout.close();
            }
            inputC = (enc = urlConn.getContentEncoding()) != null && enc.compareTo("gzip") == 0 ? new CountInputStream(new GZIPInputStream(urlConn.getInputStream())) : new CountInputStream(urlConn.getInputStream());
        } else {
            inputC = new CountInputStream(this.getClass().getResourceAsStream(url));
        }
        FilterInputStream ip = inputC;
        if (this.dtdc != null) {
            ip = new DataDisplayInputStream(ip, this.dtdc);
        }
        if ((str = (input = new BufferedReader(new InputStreamReader((InputStream)(ip = new DataInputStream(ip)), "UTF-8"))).readLine()) != null) {
            if (str.equals("<gleisdata_v3/>")) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    SAXParser saxParser = factory.newSAXParser();
                    saxParser.parse(new InputSource(input), (DefaultHandler)this);
                }
                catch (Exception e) {
                    if (e instanceof SAXParseException) {
                        SAXParseException s = (SAXParseException)e;
                        System.out.println("Parse Exception at line " + s.getLineNumber() + " column " + s.getColumnNumber());
                        System.out.println("ID: " + s.getPublicId());
                    } else {
                        e.printStackTrace();
                        System.out.println("Exception occured before char: " + inputC.getCount());
                        System.out.println("Dump: ###" + inputC.getLastRead() + "###");
                    }
                    jstlog.log(this.getClass(), (String)"updateData / SAX", (Throwable)e);
                    throw new IOException(e);
                }
            } else {
                System.out.print(str);
                data = new LinkedList<String>();
                while (null != (str = input.readLine())) {
                    System.out.println(str);
                    data.addLast(str);
                }
            }
        }
        this.dataSize = inputC.getCount();
        input.close();
        return data;
    }

    public void updateData(File f) throws IOException {
        CountInputStream inputC;
        this.dataSize = 0L;
        FilterInputStream ip = inputC = new CountInputStream(new FileInputStream(f));
        if (this.dtdc != null) {
            ip = new DataDisplayInputStream(ip, this.dtdc);
        }
        ip = new DataInputStream(ip);
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)ip, "UTF-8"));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(input), (DefaultHandler)this);
        }
        catch (Exception e) {
            if (e instanceof SAXParseException) {
                SAXParseException s = (SAXParseException)e;
                System.out.println("Parse Exception at line " + s.getLineNumber() + " column " + s.getColumnNumber());
                System.out.println("ID: " + s.getPublicId());
            } else {
                e.printStackTrace();
                System.out.println("Exception occured before char: " + inputC.getCount());
                System.out.println("Dump: ###" + inputC.getLastRead() + "###");
            }
            jstlog.log(this.getClass(), (String)"updateData / SAX", (Throwable)e);
            throw new IOException(e);
        }
        this.dataSize = inputC.getCount();
        input.close();
    }

    public void updateDataByString(String data) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(data.getBytes("UTF-8"));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)input, (DefaultHandler)this);
        }
        catch (Exception e) {
            System.out.println("Line: " + data);
            System.out.println("Ex: " + e.getMessage());
            e.printStackTrace();
        }
        input.close();
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new LinkedList();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.stack.size() > 0) {
            throw new SAXException("not empty error");
        }
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        String eName = lName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.stack.addLast(eName);
        this.stack.addLast(new AttributesImpl(attrs));
        this.stack.addLast(null);
        xmllistener l = this.listeners.get(eName);
        if (l != null) {
            try {
                l.parseStartTag(eName, attrs);
            }
            catch (Exception e) {
                jstlog.log(this.getClass(), (String)("start tag: " + eName), (Throwable)e);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        try {
            String lastpcdata = (String)this.stack.removeLast();
            Attributes lastattrib = (Attributes)this.stack.removeLast();
            String lasttag = (String)this.stack.removeLast();
            xmllistener l = this.listeners.get(lasttag);
            if (l != null) {
                try {
                    l.parseEndTag(lasttag, lastattrib, lastpcdata);
                }
                catch (Exception e) {
                    jstlog.log(this.getClass(), (String)("end tag: " + lasttag), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException("tag error", e);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = (String)this.stack.removeLast();
        s = s == null ? new String(buf, offset, len) : s + new String(buf, offset, len);
        this.stack.addLast(s);
    }
}

