/*
 * Decompiled with CFR 0.152.
 */
package js.java.plugins.monitorWand;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import js.java.stspluginlib.PluginClient;

public class connection
extends PluginClient {
    private final JMenu menu;
    private final TreeMap<String, JCheckBoxMenuItem> bahnsteige = new TreeMap();
    private String name = "";
    private ActionListener menuListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            connection.this.repaint();
        }
    };
    private ActionListener refreshListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            connection.this.request_zugliste();
        }
    };
    private Timer refreshTimer = new Timer(30000, this.refreshListener);
    private HashMap<Integer, ZugDetailFahrplan> zuglist = new HashMap();

    connection(JMenu m) {
        super("MonitorWand", "JS", "0.9", "Demo-Abfahrtwand");
        this.menu = m;
    }

    @Override
    protected void connected() {
        this.request_setdebug(true);
        this.request_anlageninfo();
        this.request_bahnsteigliste();
        this.refreshTimer.setInitialDelay(1000);
        this.refreshTimer.start();
    }

    protected void repaint() {
    }

    @Override
    protected void closed() {
        System.exit(100);
    }

    @Override
    protected void response_anlageninfo(int aid, String name, String build) {
        this.name = name;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void response_bahnsteigliste(HashMap<String, HashSet<String>> bl) {
        TreeMap<String, JCheckBoxMenuItem> treeMap = this.bahnsteige;
        synchronized (treeMap) {
            this.bahnsteige.clear();
            for (String s : bl.keySet()) {
                this.bahnsteige.put(s, null);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                connection.this.menu.removeAll();
                TreeMap treeMap = connection.this.bahnsteige;
                synchronized (treeMap) {
                    for (Map.Entry entry : connection.this.bahnsteige.entrySet()) {
                        JCheckBoxMenuItem m = new JCheckBoxMenuItem((String)entry.getKey());
                        m.setSelected(true);
                        m.addActionListener(connection.this.menuListener);
                        connection.this.menu.add(m);
                        entry.setValue(m);
                    }
                }
                connection.this.repaint();
            }
        });
    }

    @Override
    protected void response_zugliste(HashMap<Integer, String> zl) {
        for (Integer zid : zl.keySet()) {
            if (!this.zuglist.containsKey(zid)) {
                this.zuglist.put(zid, null);
            }
            this.request_zugdetails(zid);
        }
        Iterator<Integer> it = this.zuglist.keySet().iterator();
        while (it.hasNext()) {
            int zid = it.next();
            if (zl.containsKey(zid)) continue;
            it.remove();
        }
    }

    @Override
    protected void response_zugdetails(int zid, PluginClient.ZugDetails details) {
        ZugDetailFahrplan zd = this.zuglist.get(zid);
        if (zd == null) {
            zd = new ZugDetailFahrplan(details);
            this.zuglist.put(zid, zd);
            this.request_zugfahrplan(zid);
        } else {
            zd.update(details);
            this.request_zugfahrplan(zid);
        }
        this.repaint();
    }

    @Override
    protected void response_zugfahrplan(int zid, LinkedList<PluginClient.ZugFahrplanZeile> plan) {
        System.out.println("Fahrplan f\u00fcr " + zid);
        ZugDetailFahrplan zd = this.zuglist.get(zid);
        if (zd != null) {
            zd.plan = plan;
        } else {
            System.out.println("Fehler: F\u00fcr " + zid + " fehlen die Details!");
        }
    }

    public String getName() {
        return this.name;
    }

    public TreeSet<Abfahrten> getAbfahrten() {
        TreeSet<Abfahrten> ret = new TreeSet<Abfahrten>();
        for (ZugDetailFahrplan z : this.zuglist.values()) {
            if (z.gleis == null) continue;
            try {
                System.out.println("Zug: " + z.name + " von " + z.von + " ab " + z.getFormattedAb());
                for (PluginClient.ZugFahrplanZeile g : z.plan) {
                    if (!(g.flags.hasFlag('E') || g.flags.hasFlag('K') || g.flags.hasFlag('D'))) {
                        JCheckBoxMenuItem cb = this.bahnsteige.get(g.gleis);
                        boolean add = cb != null && cb.isSelected();
                        cb = this.bahnsteige.get(g.plan);
                        if (!(add |= cb != null && cb.isSelected())) continue;
                        System.out.println("zeigen");
                        ret.add(new Abfahrten(z, g));
                        continue;
                    }
                    System.out.println("Flag");
                }
            }
            catch (NullPointerException ex) {
                System.out.println("Unvollst\u00e4ndig: " + z.name + "(" + z.zid + ")");
            }
        }
        return ret;
    }

    public class Abfahrten
    implements Comparable {
        private static final String SPACER = "     ";
        public final String name;
        public final String gleis;
        public final String ab;
        public final String nach;
        public final String infotext;
        private final long abLong;

        Abfahrten(ZugDetailFahrplan z, PluginClient.ZugFahrplanZeile f) {
            String t = "";
            if (z.verspaetung > 5) {
                t = t + "ca. " + z.verspaetung / 5 * 5 + " Min sp\u00e4ter" + SPACER;
            }
            this.name = z.name;
            this.gleis = this.cleverGleis(f.gleis);
            if (!f.plan.equals(f.gleis)) {
                t = t + "Gleis\u00e4nderung von Gleis " + this.cleverGleis(f.plan) + SPACER;
            } else if (z.gleis != null && z.plangleis != null && f.plan.equals(z.plangleis) && !z.plangleis.equals(z.gleis)) {
                t = t + "Gleis\u00e4nderung von Gleis " + this.cleverGleis(z.plangleis) + SPACER;
            }
            this.abLong = f.ab;
            this.ab = f.getFormattedAb();
            this.nach = z.nach;
            if (f.flags.hasFlag('R')) {
                t = t + "Zug \u00e4ndert Fahrtrichtung     ";
            }
            if (f.flags.hasFlag('F')) {
                int fzid = f.flags.dataOfFlag('F');
                ZugDetailFahrplan fz = (ZugDetailFahrplan)connection.this.zuglist.get(fzid);
                t = fz == null || fz.nach.isEmpty() ? t + "Zug wird geteilt     " : t + "Zug wird geteilt, vorderer Zugteil nach " + this.nach + ", hinterer Zugteil als " + fz.name + " nach " + fz.nach + SPACER;
            }
            this.infotext = t;
        }

        private String cleverGleis(String g) {
            StringBuilder ret = new StringBuilder(g);
            while (ret.length() > 0 && !Character.isDigit(ret.charAt(0))) {
                ret.deleteCharAt(0);
            }
            return ret.toString();
        }

        public int compareTo(Object o) {
            Abfahrten oo = (Abfahrten)o;
            int r = (int)(this.abLong - oo.abLong);
            if (r == 0) {
                r = this.name.compareToIgnoreCase(oo.name);
            }
            if (r == 0) {
                r = this.gleis.compareToIgnoreCase(oo.gleis);
            }
            return r;
        }
    }

    private static class ZugDetailFahrplan {
        public final int zid;
        public final String name;
        public int verspaetung;
        public String gleis;
        public String plangleis;
        public final String von;
        public final String nach;
        public boolean sichtbar;
        public LinkedList<PluginClient.ZugFahrplanZeile> plan = null;

        public ZugDetailFahrplan(PluginClient.ZugDetails reference) {
            this.zid = reference.zid;
            this.name = reference.name;
            this.verspaetung = reference.verspaetung;
            this.gleis = reference.gleis;
            this.plangleis = reference.plangleis;
            this.von = reference.von;
            this.nach = reference.nach;
            this.sichtbar = reference.sichtbar;
        }

        public String getFormattedAn() {
            try {
                return this.plan.getFirst().getFormattedAn();
            }
            catch (NullPointerException e) {
                return "";
            }
            catch (NoSuchElementException e) {
                return "";
            }
        }

        public String getFormattedAb() {
            try {
                return this.plan.getFirst().getFormattedAb();
            }
            catch (NullPointerException e) {
                return "";
            }
            catch (NoSuchElementException e) {
                return "";
            }
        }

        public long getAb() {
            try {
                return this.plan.getFirst().ab;
            }
            catch (NullPointerException e) {
                return 0L;
            }
            catch (NoSuchElementException e) {
                return 0L;
            }
        }

        public boolean update(PluginClient.ZugDetails other) {
            boolean ret = !this.plangleis.equals(other.plangleis);
            this.verspaetung = other.verspaetung;
            this.sichtbar = other.sichtbar;
            this.gleis = other.gleis;
            this.plangleis = other.plangleis;
            return ret;
        }
    }
}

