/*
 * Decompiled with CFR 0.152.
 */
package js.java.plugins.monitorWand;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.Timer;
import js.java.plugins.monitorWand.connection;
import js.java.schaltungen.timesystem.TimeFormat;

public class wand
extends JComponent {
    private static final int BIGFONTHEIGHT = 22;
    private static final int NORMALFONTHEIGHT = 18;
    private static final int SMALLFONTHEIGHT = 14;
    private int bigfontheight;
    private int normalfontheight;
    private int smallfontheight;
    private ActionListener refreshListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            wand.this.a = wand.this.c.getAbfahrten();
            wand.this.x = 0;
            wand.this.repaint();
        }
    };
    private ActionListener scrollListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (wand.this.a != null) {
                wand.this.x += wand.this.scaleOffset;
                wand.this.repaint();
            }
        }
    };
    private Timer refreshTimer = new Timer(30000, this.refreshListener);
    private Timer scrollTimer = new Timer(70, this.scrollListener);
    private Color bgcolor = new Color(0, 0, 204);
    private Color fgcolor = new Color(255, 255, 255);
    private Font bigfont;
    private Font normalfont;
    private Font smallfont;
    private final connection c;
    private TreeSet<connection.Abfahrten> a = null;
    private int scaleOffset = 1;
    private int x = 0;
    private TimeFormat tf = TimeFormat.getInstance(TimeFormat.STYLE.HM);

    wand(connection c) {
        this.c = c;
        this.setOpaque(true);
        this.setScale(0);
        this.refreshTimer.start();
        this.scrollTimer.start();
    }

    void setScale(int value) {
        this.bigfontheight = 22 * (10 + value) / 10;
        this.normalfontheight = 18 * (10 + value) / 10;
        this.smallfontheight = 14 * (10 + value) / 10;
        this.bigfont = new Font("SansSerif", 1, this.bigfontheight);
        this.normalfont = new Font("SansSerif", 0, this.normalfontheight);
        this.smallfont = new Font("SansSerif", 1, this.smallfontheight);
        this.scaleOffset = (10 + value) / 10 / 2 + 1;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.bgcolor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawHead(g2);
        this.drawTrains(g2);
    }

    private void drawHead(Graphics2D g2) {
        g2.setColor(this.fgcolor);
        g2.fillRect(0, 0, this.getWidth(), this.bigfontheight + 6);
        g2.setColor(this.bgcolor);
        g2.setFont(this.bigfont);
        FontMetrics fm = g2.getFontMetrics();
        g2.drawString("Abfahrt", 10, this.bigfontheight - fm.getDescent() + 4);
        g2.drawString(this.c.getName(), this.bigfontheight * 5, this.bigfontheight - fm.getDescent() + 4);
        String time = this.tf.formatTime(this.c.getSimutime());
        g2.drawString(time, this.getWidth() - this.bigfontheight * 3, this.bigfontheight - fm.getDescent() + 4);
    }

    private void drawTrains(Graphics2D g2) {
        if (this.a != null) {
            int y = this.bigfontheight + 10;
            for (connection.Abfahrten f : this.a) {
                if ((y += this.normalfontheight) > this.getHeight()) break;
                g2.setColor(this.fgcolor);
                g2.setFont(this.normalfont);
                FontMetrics fm = g2.getFontMetrics();
                g2.drawString(f.ab, 20, y - fm.getDescent());
                g2.drawString(f.name, this.bigfontheight * 3, y - fm.getDescent());
                g2.drawString(f.nach, this.bigfontheight * 8, y - fm.getDescent());
                int w = fm.stringWidth(f.gleis);
                g2.setColor(this.bgcolor);
                g2.fillRect(this.getWidth() - w - 10 - 10, y - this.normalfontheight, w + 20, this.normalfontheight);
                g2.setColor(this.fgcolor);
                g2.drawString(f.gleis, this.getWidth() - w - 10, y - fm.getDescent());
                if (!f.infotext.isEmpty()) {
                    g2.fillRect(0, (y += this.smallfontheight + 2) - this.smallfontheight - 2, this.getWidth(), this.smallfontheight + 5);
                    g2.setColor(this.bgcolor);
                    g2.setFont(this.smallfont);
                    fm = g2.getFontMetrics();
                    w = fm.stringWidth(f.infotext);
                    int cnt = 0;
                    do {
                        g2.drawString(f.infotext, -this.x + w * cnt, y - fm.getDescent() + 2);
                    } while (-this.x + w * (++cnt - 1) < this.getWidth());
                    y += 5;
                }
                y += 5;
            }
        }
    }
}

